// types.h
// ----------------------------------------------------------------------------------
// Global Types for the Spell Checker project.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
// For machine portability all variables that need to be a specific size are 
// defined here.
// Global constants and types are likewise defined here.
// ----------------------------------------------------------------------------------
// History:
//		Clark Goble			08/09/94
//			Original.
//		CG					08/11/94
//			Added various definitions from spelldef.h.  Centralized
//			all the various commonly used macros and consts.
// ----------------------------------------------------------------------------------

#include <stdio.h>
#include "UBloom.h"
#include "UIndex.h"
#include "UData.h"


// ----------------------------------------------------------------------------------

// tells where we are in the dictionary
typedef struct {
	char *Word;
	char *LastWord;
	int  CurrentNibble;
	int  CurrentPage;
	int  EndOfPage;
	UInt8 *DictPage;
} CURSOR;

// a main dictionary
typedef struct {
	FILE 		*DictFile;		// the physical data file
	UBloom 		*FrequentWords;	// list of frequent words
	UIndex 		*Index;			// index of dictionary - tells page word is on
	UDataFile 	*Buffers;		// buffered file
	CURSOR 		Cursor;			// current location in dictionary
	
	long FWFilterSize;		// frequent word bloom filter size
	long FWFilterOffset;	// offset in file to the bloom filter
	
	long NumPages;    		// The number of pages the compressed word list takes up.
	long PageSize;   		// The size of each of the various pages 
	long PageOffset;  		// Offset for the begining page of the compressed word list
	long IndexOffset; 		// Offset for the index for the various pages 
	long Version;     		// The current version of the index structure 
	
} DICTIONARY;


